/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.mib;

import ibm.nways.jdm.mib.MibModule;
import ibm.nways.jdm.mib.MibRangeSubtype;
import ibm.nways.jdm.mib.MibType;
import ibm.nways.jdm.mib.MibValueSubtype;

public class MibInteger
extends MibType {
    public MibInteger(MibModule mibModule) {
        super(mibModule);
    }

    public MibInteger(MibModule mibModule, String string) {
        super(mibModule, string);
    }

    public MibInteger(MibModule mibModule, String string, MibRangeSubtype mibRangeSubtype) {
        super(mibModule, string);
        this.addRangeSubtype(mibRangeSubtype);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isBoolean()) {
            stringBuffer.append("Boolean");
        } else if (this.isEnumerated()) {
            stringBuffer.append("Enumerated");
            if (this.allowedValues != null) {
                stringBuffer.append(this.allowedValues.toString());
            }
        } else {
            stringBuffer.append("Integer");
            if (this.range != null) {
                stringBuffer.append(this.range.toString());
            }
        }
        return stringBuffer.toString();
    }

    public void addNamedNumber(String string, int n) {
        if (this.allowedValues == null) {
            this.allowedValues = new MibValueSubtype();
        }
        this.allowedValues.addValue(string, new Integer(n));
    }

    public int getNamedNumber(String string) {
        return (Integer)this.allowedValues.getValue(string);
    }

    public boolean isAllowedValue(String string) {
        if (this.allowedValues == null) {
            return true;
        }
        return this.allowedValues.isValue(string);
    }

    public boolean isBoolean() {
        boolean bl = false;
        if (this.allowedValues != null && this.allowedValues.size() == 2) {
            Integer n;
            Integer n2;
            if (this.allowedValues.isValue("true") && this.allowedValues.isValue("false")) {
                n2 = (Integer)this.allowedValues.getValue("true");
                n = (Integer)this.allowedValues.getValue("false");
                if (n2 == 1 && n == 2) {
                    bl = true;
                }
            }
            if (this.allowedValues.isValue("yes") && this.allowedValues.isValue("no")) {
                n2 = (Integer)this.allowedValues.getValue("yes");
                n = (Integer)this.allowedValues.getValue("no");
                if (n2 == 1 && n == 2) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public boolean isEnumerated() {
        return this.allowedValues != null && !this.isBoolean();
    }

    public MibType getActualType() {
        return this;
    }

    public int getTypeEnum() {
        return 3;
    }
}

